/*
SQLyog Community Edition- MySQL GUI v5.29
Host - 5.1.41 : Database - tiket
*********************************************************************
Server version : 5.1.41
*/


/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

create database if not exists `tiket`;

USE `tiket`;

/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

/*Table structure for table `tb_abk` */

DROP TABLE IF EXISTS `tb_abk`;

CREATE TABLE `tb_abk` (
  `id_abk` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) DEFAULT NULL,
  `alamat` varchar(100) DEFAULT NULL,
  `telp` varchar(100) DEFAULT NULL,
  `status` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id_abk`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

/*Data for the table `tb_abk` */

insert  into `tb_abk`(`id_abk`,`nama`,`alamat`,`telp`,`status`) values (1,'sengkog','denpasar','087886875566','1'),(2,'bleket','gianyar','08667877756','1');

/*Table structure for table `tb_angkutan` */

DROP TABLE IF EXISTS `tb_angkutan`;

CREATE TABLE `tb_angkutan` (
  `id_angkutan` int(11) NOT NULL AUTO_INCREMENT,
  `id_jenis_angkutan` int(11) DEFAULT NULL,
  `nama` varchar(255) DEFAULT NULL,
  `keterangan` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id_angkutan`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;

/*Data for the table `tb_angkutan` */

insert  into `tb_angkutan`(`id_angkutan`,`id_jenis_angkutan`,`nama`,`keterangan`) values (1,1,'Dewasa','-'),(2,1,'Anak - anak','-'),(3,2,'Golongan I','Sepeda Gayung'),(4,2,'Golongan II','Sepeda Motor dibawah 500 cc dan gerobak'),(5,2,'Golongan III','Sepeda Motor diatas 500 cc dan kendaraan roda 3'),(6,2,'Golongan IV A','Kendaraan Bermotor berupa jeep, sedan, minicab, minibus, microlet, pick up, stationwagon dengan panjang 5m dan sejenisnya'),(7,2,'Golongan IV B','Kendaraan Bermotor berupa jeep, sedan, minicab, minibus, microlet, pick up, stationwagon dengan panjang 5m dan sejenisnya'),(8,2,'Golongan V A','Kendaraan bermotor berupa mobil bus,mobil barang (truk) / tangki ukuran panjang sampai 7 m dan sejenisnya'),(9,2,'Golongan V B','Kendaraan bermotor berupa mobil bus,mobil barang (truk) / tangki ukuran panjang sampai 7 m dan sejenisnya'),(10,2,'Golongan VI A','Kendaraan bermotor berupa mobil bus,mobil barang (truk) / tangki ukuran panjang sampai 7 m sampai 10 m'),(11,2,'Golongan VI B','Kendaraan bermotor berupa mobil bus,mobil barang (truk) / tangki ukuran panjang sampai 7 m sampai 10 m'),(12,2,'Golongan VII','Kendaraan bermotor berupa mobil barang (truk tronton)/tangki, kereta penarik berikut gandengan, serta alat berat sepanjang lebih dari 10 sampai 12 m dan sejenisnya'),(13,2,'Golongan VIII','Kendaraan bermotor berupa mobil barang (truk tronton)/tangki, kereta penarik berikut gandengan, serta alat berat sepanjang lebih dari 12 m dan sejenisnya');

/*Table structure for table `tb_booking` */

DROP TABLE IF EXISTS `tb_booking`;

CREATE TABLE `tb_booking` (
  `Id_Booking` varchar(20) NOT NULL,
  `Id_Member` varchar(100) DEFAULT NULL,
  `Tanggal` date DEFAULT NULL,
  `Status` char(10) DEFAULT NULL,
  PRIMARY KEY (`Id_Booking`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

/*Data for the table `tb_booking` */

/*Table structure for table `tb_detil_angkutan` */

DROP TABLE IF EXISTS `tb_detil_angkutan`;

CREATE TABLE `tb_detil_angkutan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_jadwal` varchar(100) DEFAULT NULL,
  `id_angkutan` int(100) DEFAULT NULL,
  `harga` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;

/*Data for the table `tb_detil_angkutan` */

insert  into `tb_detil_angkutan`(`id`,`id_jadwal`,`id_angkutan`,`harga`) values (1,'1',1,27380),(2,'1',2,22380),(3,'1',3,13730),(4,'1',4,39080),(5,'1',5,46580),(6,'1',6,277880),(7,'1',7,200280),(8,'1',8,468280),(9,'1',9,355380),(10,'1',10,805280),(11,'1',11,580080),(12,'1',12,927830),(13,'1',13,1688980);

/*Table structure for table `tb_detil_booking` */

DROP TABLE IF EXISTS `tb_detil_booking`;

CREATE TABLE `tb_detil_booking` (
  `Id_Detil_Booking` int(11) NOT NULL AUTO_INCREMENT,
  `Id_Booking` varchar(100) DEFAULT NULL,
  `Id_Jadwal` varchar(100) DEFAULT NULL,
  `Nama_Costumer` varchar(100) DEFAULT NULL,
  `Tipe_Kartu_Identitas` varchar(100) DEFAULT NULL,
  `No_Kartu_Identitas` varchar(100) DEFAULT NULL,
  `Alamat` varchar(255) DEFAULT NULL,
  `No_Telp` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`Id_Detil_Booking`)
) ENGINE=MyISAM AUTO_INCREMENT=238 DEFAULT CHARSET=latin1;

/*Data for the table `tb_detil_booking` */

/*Table structure for table `tb_jadwal` */

DROP TABLE IF EXISTS `tb_jadwal`;

CREATE TABLE `tb_jadwal` (
  `Id_Jadwal` int(11) NOT NULL AUTO_INCREMENT,
  `Waktu` varchar(10) DEFAULT NULL,
  `Id_Kapal` varchar(50) DEFAULT NULL,
  `Id_Nahkoda` varchar(50) DEFAULT NULL,
  `Kuota_Order` int(11) DEFAULT NULL,
  `Sisa` int(11) DEFAULT NULL,
  `Dari` varchar(255) DEFAULT NULL,
  `Tujuan` varchar(255) DEFAULT NULL,
  `Status` char(1) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  PRIMARY KEY (`Id_Jadwal`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

/*Data for the table `tb_jadwal` */

insert  into `tb_jadwal`(`Id_Jadwal`,`Waktu`,`Id_Kapal`,`Id_Nahkoda`,`Kuota_Order`,`Sisa`,`Dari`,`Tujuan`,`Status`,`tanggal`) values (1,'09:00','2','1',200,199,'7','2','1','2017-03-17');

/*Table structure for table `tb_jadwal_detil` */

DROP TABLE IF EXISTS `tb_jadwal_detil`;

CREATE TABLE `tb_jadwal_detil` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_jadwal` varchar(100) DEFAULT NULL,
  `id_abk` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

/*Data for the table `tb_jadwal_detil` */

/*Table structure for table `tb_jenis_angkutan` */

DROP TABLE IF EXISTS `tb_jenis_angkutan`;

CREATE TABLE `tb_jenis_angkutan` (
  `id_jenis_angkutan` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(255) DEFAULT NULL,
  `keterangan` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id_jenis_angkutan`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

/*Data for the table `tb_jenis_angkutan` */

insert  into `tb_jenis_angkutan`(`id_jenis_angkutan`,`nama`,`keterangan`) values (1,'Penumpang','-'),(2,'Kendaraan','-');

/*Table structure for table `tb_jenis_kapal` */

DROP TABLE IF EXISTS `tb_jenis_kapal`;

CREATE TABLE `tb_jenis_kapal` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `Jenis` varchar(100) DEFAULT NULL,
  `Keterangan` text,
  `Status` char(1) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

/*Data for the table `tb_jenis_kapal` */

insert  into `tb_jenis_kapal`(`Id`,`Jenis`,`Keterangan`,`Status`) values (1,'SPEED BOAT','-','1'),(2,'KAPAL RORO','-','1'),(3,'JUKUNG / SAMPAN','-','1');

/*Table structure for table `tb_kapal` */

DROP TABLE IF EXISTS `tb_kapal`;

CREATE TABLE `tb_kapal` (
  `Id_Kapal` int(11) NOT NULL AUTO_INCREMENT,
  `Id_Jenis` varchar(50) DEFAULT NULL,
  `Nama` varchar(255) DEFAULT NULL,
  `Jumlah_Kursi` int(11) DEFAULT NULL,
  `Status` char(1) DEFAULT NULL,
  PRIMARY KEY (`Id_Kapal`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

/*Data for the table `tb_kapal` */

insert  into `tb_kapal`(`Id_Kapal`,`Id_Jenis`,`Nama`,`Jumlah_Kursi`,`Status`) values (1,'3','TRIBUANA',40,'1'),(2,'2','NUSA JAYA ABADI',200,'1'),(3,'1','DWI MANUNGGAL',30,'1'),(4,'1','MARUTI EXPRESS',30,'1');

/*Table structure for table `tb_kartu_identitas` */

DROP TABLE IF EXISTS `tb_kartu_identitas`;

CREATE TABLE `tb_kartu_identitas` (
  `Id_Kartu` int(11) NOT NULL AUTO_INCREMENT,
  `Jenis` varchar(100) DEFAULT NULL,
  `Keterangan` varchar(255) DEFAULT NULL,
  `Status` char(1) DEFAULT NULL,
  PRIMARY KEY (`Id_Kartu`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

/*Data for the table `tb_kartu_identitas` */

insert  into `tb_kartu_identitas`(`Id_Kartu`,`Jenis`,`Keterangan`,`Status`) values (1,'KTP','-','1'),(2,'SIM','-','1'),(3,'Kartu Pelajar','-','1'),(4,'Pasport','-','1');

/*Table structure for table `tb_kartu_kredit` */

DROP TABLE IF EXISTS `tb_kartu_kredit`;

CREATE TABLE `tb_kartu_kredit` (
  `Id_Kartu` int(11) NOT NULL AUTO_INCREMENT,
  `Jenis` varchar(100) DEFAULT NULL,
  `Keterangan` varchar(255) DEFAULT NULL,
  `Status` char(1) DEFAULT NULL,
  PRIMARY KEY (`Id_Kartu`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

/*Data for the table `tb_kartu_kredit` */

insert  into `tb_kartu_kredit`(`Id_Kartu`,`Jenis`,`Keterangan`,`Status`) values (1,'BCA','-','1'),(2,'BRI','-','1'),(3,'BNI','-','1'),(4,'Bank Lain','-','1');

/*Table structure for table `tb_member` */

DROP TABLE IF EXISTS `tb_member`;

CREATE TABLE `tb_member` (
  `Id_Member` int(11) NOT NULL AUTO_INCREMENT,
  `Nama` varchar(100) DEFAULT NULL,
  `Alamat` varchar(255) DEFAULT NULL,
  `Telp` varchar(50) DEFAULT NULL,
  `Email` varchar(100) DEFAULT NULL,
  `Password` varchar(50) DEFAULT NULL,
  `Tgl_Gabung` date DEFAULT NULL,
  `Status` char(1) DEFAULT NULL,
  PRIMARY KEY (`Id_Member`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=latin1;

/*Data for the table `tb_member` */

/*Table structure for table `tb_nahkoda` */

DROP TABLE IF EXISTS `tb_nahkoda`;

CREATE TABLE `tb_nahkoda` (
  `Id_Nahkoda` int(11) NOT NULL AUTO_INCREMENT,
  `Nahkoda` varchar(200) DEFAULT NULL,
  `Alamat` varchar(255) DEFAULT NULL,
  `No_Telp` varchar(100) DEFAULT NULL,
  `Status` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`Id_Nahkoda`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

/*Data for the table `tb_nahkoda` */

insert  into `tb_nahkoda`(`Id_Nahkoda`,`Nahkoda`,`Alamat`,`No_Telp`,`Status`) values (1,'alex','nusa penida','-','1'),(2,'jhon','denpasar','08889768','1');

/*Table structure for table `tb_operator` */

DROP TABLE IF EXISTS `tb_operator`;

CREATE TABLE `tb_operator` (
  `id_operator` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) DEFAULT NULL,
  `password` varchar(100) DEFAULT NULL,
  `akses` varchar(100) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_operator`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

/*Data for the table `tb_operator` */

insert  into `tb_operator`(`id_operator`,`nama`,`password`,`akses`,`status`) values (1,'bayu','admin','Admin',1),(2,'Ajun','12345','Operator',1);

/*Table structure for table `tb_pelabuhan` */

DROP TABLE IF EXISTS `tb_pelabuhan`;

CREATE TABLE `tb_pelabuhan` (
  `Id_Pelabuhan` int(11) NOT NULL AUTO_INCREMENT,
  `Nama` varchar(255) DEFAULT NULL,
  `Keterangan` text,
  `Status` char(1) DEFAULT NULL,
  PRIMARY KEY (`Id_Pelabuhan`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

/*Data for the table `tb_pelabuhan` */

insert  into `tb_pelabuhan`(`Id_Pelabuhan`,`Nama`,`Keterangan`,`Status`) values (1,'PEL. SANUR','DENPASAR','1'),(2,'PEL. PADANG BAY','KARANGASEM','1'),(3,'PEL. KUSAMBA','KLUNGKUNG','1'),(4,'PEL. TOYA PAKEH','KLUNGKUNG','1'),(5,'PEL. KUTAMPI','KLUNGKUNG','1'),(6,'PEL. NYUH KUKUH','KLUNGKUNG','1'),(7,'PEL. PENYEBERANGAN NUSA PENIDA','NUSA PENIDA','1');

/*Table structure for table `tb_pembayaran` */

DROP TABLE IF EXISTS `tb_pembayaran`;

CREATE TABLE `tb_pembayaran` (
  `Id_Pembayaran` int(11) NOT NULL AUTO_INCREMENT,
  `Bank_Tujuan` varchar(100) DEFAULT NULL,
  `Bank_Dari` varchar(100) DEFAULT NULL,
  `AN_Rekening` varchar(100) DEFAULT NULL,
  `Id_Booking` varchar(100) DEFAULT NULL,
  `Jumlah_Transfer` varchar(100) DEFAULT NULL,
  `Id_Member` varchar(100) DEFAULT NULL,
  `Tgl_Pembayaran` date DEFAULT NULL,
  `Status` char(10) DEFAULT NULL,
  PRIMARY KEY (`Id_Pembayaran`)
) ENGINE=MyISAM AUTO_INCREMENT=106 DEFAULT CHARSET=latin1;

/*Data for the table `tb_pembayaran` */

/*Table structure for table `tb_tiket` */

DROP TABLE IF EXISTS `tb_tiket`;

CREATE TABLE `tb_tiket` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_jadwal` int(11) DEFAULT NULL,
  `id_angkutan` int(11) DEFAULT NULL,
  `harga` bigint(20) DEFAULT NULL,
  `nama` varchar(200) DEFAULT NULL,
  `no_identitas` varchar(200) DEFAULT NULL,
  `tanggal` datetime DEFAULT NULL,
  `no_tiket` varchar(100) DEFAULT NULL,
  `id_operator` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

/*Data for the table `tb_tiket` */

insert  into `tb_tiket`(`id`,`id_jadwal`,`id_angkutan`,`harga`,`nama`,`no_identitas`,`tanggal`,`no_tiket`,`id_operator`) values (1,3,1,100000,'Wayan Sarjana','1234567889','2017-02-15 13:45:29','150220171',''),(2,3,1,100000,'Ni Made Wetri','0786478863292','2017-02-15 13:46:09','150220172',''),(3,3,2,200000,'Putu Natalia','1223534535','2017-02-15 13:46:52','150220173',''),(4,3,2,200000,'Kadek Pedo Yasa','9768797576768','2017-02-15 13:47:31','150220174',''),(5,3,6,600000,'Avanza DK 9090 GQ','9885678608089','2017-02-15 13:48:25','150220175',''),(6,3,11,120000,'Hino 220 DK 7643 SJ','123235345346456','2017-02-15 13:49:11','150220176',''),(7,3,2,200000,'Putu Ajun Wira Githa','1343427582743','2017-02-15 14:04:12','150220177',''),(8,1,1,10000,'Ketut Wena','25345436456','2017-02-15 14:05:15','150220178',''),(9,1,4,200000,'made',' 123455','2017-02-16 01:24:48','160220171',''),(10,1,1,10000,'maaas','6566','2017-02-16 01:33:41','160220172',''),(11,1,1,0,'made1','223','2017-03-17 02:11:42','170320171','');

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
